/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 4-BIT  FULL ADDERS WITH FAST CARRY 
TRUTHTABLE     : 

      ---------------------------------------------------------
         INPUT :           C0/C2=L                C0/C2=H
       A1 B1  A2 B2   SIGMA1 SIGMA2  C2     SIGMA1 SIGMA2  C2
       A3 B3  A4 B4   SIGMA3 SIGMA4  C4     SIGMA3 SIGMA4  C4
      ---------------------------------------------------------
       L  L   L  L       L      L      L       H      L      L
       H  L   L  L       H      L      L       L      H      L
       L  H   L  L       H      L      L       L      H      L
       H  H   L  L       L      H      L       H      H      L
       L  L   H  L       L      H      L       H      H      L
       H  L   H  L       H      H      L       L      L      H
       L  H   H  L       H      H      L       L      L      H
       H  H   H  L       L      L      H       H      L      H
       L  L   L  H       L      H      L       H      H      L
       H  L   L  H       H      H      L       L      L      H
       L  H   L  H       H      H      L       L      L      H
       H  H   L  H       L      L      H       H      L      H
       L  L   H  H       L      L      H       H      L      H
       H  L   H  H       H      L      H       L      H      H
       L  H   H  H       H      L      H       L      H      H
       H  H   H  H       L      H      H       H      H      H  
      --------------------------------------------------------- 
          
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a283 (sum2, b2, a2, sum1, a1, b1, c0, c4, sum4, b4, a4, sum3, a3, b3);
	parameter size =1;
	input
		a1,
		a2,
		a3,
		a4,
		b1,
		b2,
		b3,
		b4,
		c0;
	output
		sum1,
		sum2,
		sum3,
		sum4,
		c4;
    nand
	M283_inst_ND1 (m283_inst_wnd1, b4, a4);
    nand
	M283_inst_ND2 (m283_inst_wnd2, b3, a3);
    nand
	M283_inst_ND3 (m283_inst_wnd3, b2, a2);
    nand
	M283_inst_ND4 (m283_inst_wnd4, b1, a1);
    not
	M283_inst_I1 (m283_inst_wi1, c0);
    not
	M283_inst_I2 (m283_inst_wi2, m283_inst_wi1);
    not
	M283_inst_I3 (m283_inst_wi3, m283_inst_wn5);
    not
	M283_inst_I4 (m283_inst_wi4, m283_inst_wn6);
    not
	M283_inst_I5 (m283_inst_wi5, m283_inst_wn7);
    not
	M283_inst_I6 (m283_inst_wi6, m283_inst_wn8);
    xor  
	M283_inst_X1 (sum4, m283_inst_wan5, m283_inst_wn2);
    xor  
	M283_inst_X2 (sum3, m283_inst_wan9, m283_inst_wn3);
    xor  
	M283_inst_X3 (sum2, m283_inst_wan12, m283_inst_wn4);
    xor  
	M283_inst_X4 (sum1, m283_inst_wan14, m283_inst_wi2);
    and
	M283_inst_AN1 (m283_inst_wan1, m283_inst_wn6, m283_inst_wnd1);
    and
	M283_inst_AN2 (m283_inst_wan2, m283_inst_wn7, m283_inst_wnd1, m283_inst_wnd2);
    and
	M283_inst_AN3 (m283_inst_wan3, m283_inst_wn8, m283_inst_wnd1, m283_inst_wnd2, m283_inst_wnd3);
    and
	M283_inst_AN4 (m283_inst_wan4, m283_inst_wnd1, m283_inst_wnd2, m283_inst_wnd3, m283_inst_wnd4, m283_inst_wi1);
    and
	M283_inst_AN5 (m283_inst_wan5, m283_inst_wnd1, m283_inst_wi3);
    and
	M283_inst_AN6 (m283_inst_wan6, m283_inst_wn7, m283_inst_wnd2);
    and
	M283_inst_AN7 (m283_inst_wan7, m283_inst_wn8, m283_inst_wnd2, m283_inst_wnd3);
    and
	M283_inst_AN8 (m283_inst_wan8, m283_inst_wnd2, m283_inst_wnd3, m283_inst_wnd4, m283_inst_wi1);
    and
	M283_inst_AN9 (m283_inst_wan9, m283_inst_wnd2, m283_inst_wi4);
    and
	M283_inst_AN10 (m283_inst_wan10, m283_inst_wn8, m283_inst_wnd3);
    and
	M283_inst_AN11 (m283_inst_wan11, m283_inst_wnd3, m283_inst_wnd4, m283_inst_wi1);
    and
	M283_inst_AN12 (m283_inst_wan12, m283_inst_wnd3, m283_inst_wi5);
    and
	M283_inst_AN13 (m283_inst_wan13, m283_inst_wnd4, m283_inst_wi1);
    and
	M283_inst_AN14 (m283_inst_wan14, m283_inst_wnd4, m283_inst_wi6);
    nor  
	M283_inst_N1 (c4, m283_inst_wbuf1, m283_inst_wan1, m283_inst_wan2, m283_inst_wan3, m283_inst_wan4);
    nor
	M283_inst_N2 (m283_inst_wn2, m283_inst_wbuf2, m283_inst_wan6, m283_inst_wan7, m283_inst_wan8);
    nor
	M283_inst_N3 (m283_inst_wn3, m283_inst_wbuf3, m283_inst_wan10, m283_inst_wan11);
    nor
	M283_inst_N4 (m283_inst_wn4, m283_inst_wbuf4, m283_inst_wan13);
    nor
	M283_inst_N5 (m283_inst_wn5, b4, a4);
    nor
	M283_inst_N6 (m283_inst_wn6, b3, a3);
    nor
	M283_inst_N7 (m283_inst_wn7, b2, a2);
    nor
	M283_inst_N8 (m283_inst_wn8, b1, a1);
    buf
	M283_inst_BUF1 (m283_inst_wbuf1, m283_inst_wn5);
    buf
	M283_inst_BUF2 (m283_inst_wbuf2, m283_inst_wn6);
    buf
	M283_inst_BUF3 (m283_inst_wbuf3, m283_inst_wn7);
    buf
	M283_inst_BUF4 (m283_inst_wbuf4, m283_inst_wn8);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
